/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.config;

import filenet.vw.apps.config.VWConfigToolBar;
import filenet.vw.apps.config.resources.VWResource;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.IVWConfigActionListener;
import filenet.vw.toolkit.admin.IVWConfigStatusListener;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigActionEvent;
import filenet.vw.toolkit.admin.VWConfigAppSpaceNode;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigContextMenu;
import filenet.vw.toolkit.admin.VWConfigEventLogNode;
import filenet.vw.toolkit.admin.VWConfigPerformer;
import filenet.vw.toolkit.admin.VWConfigQueueNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigRootNode;
import filenet.vw.toolkit.admin.VWConfigRosterNode;
import filenet.vw.toolkit.admin.VWConfigStatusEvent;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.changes.VWConfigChangesPane;
import filenet.vw.toolkit.admin.content.VWConfigContentPane;
import filenet.vw.toolkit.admin.scope.VWConfigScopePane;
import filenet.vw.toolkit.design.canvas.IVWDesignerCanvasPanel;
import filenet.vw.toolkit.design.canvas.config.VWDesignerRegionNode;
import filenet.vw.toolkit.design.canvas.config.VWDesignerRootNode;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class VWConfigCanvasPanel
extends JPanel
implements IVWDesignerCanvasPanel,
IVWConfigStatusListener,
IVWConfigActionListener,
ActionListener,
IVWCoordinationEventListener {
    private VWConfigToolBar m_vwToolBar = null;
    private VWConfigScopePane m_vwScopePane = null;
    private VWConfigContentPane m_vwContentPane = null;
    private VWConfigChangesPane m_vwChangesPane = null;
    private VWConfigPerformer m_performer = null;
    private EventListenerList m_listenerList = new EventListenerList();
    private Vector m_modifiedNodes = null;
    private VWDesignerCoreData m_designerCoreData = null;
    private VWDesignerRootNode m_consoleRoot = null;
    private VWConfigRootNode m_configData = null;
    private VWConfigBaseNode m_focus = null;

    public VWConfigCanvasPanel(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
        VWSessionInfo sessionInfo = designerCoreData.getSessionInfo();
        String title = "Process Designer";
        try {
            title = VWIDMBaseFactory.instance().getVWString(5).toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_performer = new VWConfigPerformer(sessionInfo, title);
        this.createControls();
        this.addConfigActionListener(this.m_vwContentPane);
        this.addConfigActionListener(this.m_vwScopePane);
        this.addConfigActionListener(this.m_vwToolBar);
        this.m_vwContentPane.addConfigActionListener(this);
        this.m_vwContentPane.addConfigActionListener(this.m_vwScopePane);
        this.m_vwContentPane.addConfigActionListener(this.m_vwToolBar);
        this.m_vwScopePane.addConfigActionListener(this);
        this.m_vwScopePane.addConfigActionListener(this.m_vwContentPane);
        this.m_vwScopePane.addConfigActionListener(this.m_vwToolBar);
        this.m_configData.addConfigStatusListener(this);
        this.m_configData.addConfigStatusListener(this.m_vwChangesPane);
        this.m_configData.addConfigStatusListener(this.m_vwToolBar);
        this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
        this.m_vwToolBar.requestFocus();
        designerCoreData.getCoordinationEventNotifier().addCoordinationEventListener(this);
    }

    public boolean isOkayToExit() {
        boolean bOkayToExit = true;
        if (this.m_performer != null) {
            if (this.m_vwToolBar != null && this.m_vwToolBar.getIsEditingSolution()) {
                return true;
            }
            this.setFocusToFirstRegionNode();
            bOkayToExit = this.m_performer.promptBeforeCommit((VWConfigRegionNode)this.m_focus, true);
            this.setFocusToFirstRegionNode();
        }
        return bOkayToExit;
    }

    public void fireRefreshRegionConfigEvent(boolean bUseCurrentConfig) {
        this.setFocusToFirstRegionNode();
        boolean bEditingSolution = false;
        if (this.m_focus != null && this.m_focus instanceof VWDesignerRegionNode) {
            bEditingSolution = ((VWDesignerRegionNode)this.m_focus).isEditingSolution();
            ((VWDesignerRegionNode)this.m_focus).setUseCurrentConfiguration(bUseCurrentConfig);
        }
        if (this.m_vwToolBar != null) {
            this.m_vwToolBar.setIsEditingSolution(bEditingSolution);
        }
        this.actionPerformed(new ActionEvent(this, -1, VWConfigActionCommand.ACMD_REFRESH));
        if (this.m_focus != null && this.m_focus instanceof VWDesignerRegionNode) {
            ((VWDesignerRegionNode)this.m_focus).setUseCurrentConfiguration(false);
        }
    }

    public void handleDiscardChangesEvent() {
        this.setFocusToFirstRegionNode();
        try {
            if (this.m_focus != null && this.m_focus instanceof VWDesignerRegionNode) {
                ((VWDesignerRegionNode)this.m_focus).discardChanges(2);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (this.m_vwToolBar != null) {
            this.m_vwToolBar.setIsEditingSolution(false);
        }
        this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 48));
    }

    public void initializeActionMenu(JMenu actionMenu) {
        if (actionMenu != null) {
            actionMenu.removeAll();
        }
    }

    public void initializeEditMenu(JMenu editMenu) {
        if (editMenu != null) {
            editMenu.removeAll();
        }
    }

    public void releaseReferences() {
        this.m_vwScopePane = null;
        this.m_vwContentPane = null;
        this.m_vwChangesPane = null;
        this.m_listenerList = null;
        if (this.m_modifiedNodes != null) {
            this.m_modifiedNodes.removeAllElements();
            this.m_modifiedNodes = null;
        }
        this.m_designerCoreData = null;
        this.m_consoleRoot = null;
        this.m_configData = null;
        this.m_focus = null;
    }

    public void configStatusChanged(VWConfigStatusEvent event) {
        String itemName = null;
        VWCoordinationEvent newEvent = null;
        VWConfigBaseNode eventNode = event.getBaseNode();
        if (eventNode != null) {
            itemName = eventNode.getName();
        }
        switch (event.getType()) {
            case 13: {
                newEvent = new VWCoordinationEvent(this, 760, itemName);
                break;
            }
            case 14: {
                newEvent = new VWCoordinationEvent(this, 761, itemName);
                break;
            }
            case 11: {
                newEvent = new VWCoordinationEvent(this, 780, itemName);
                break;
            }
            case 9: {
                newEvent = new VWCoordinationEvent(this, 770, itemName);
                break;
            }
            case 7: {
                newEvent = new VWCoordinationEvent(this, 771, itemName);
                break;
            }
            case 10: {
                newEvent = new VWCoordinationEvent(this, 775, itemName);
                break;
            }
            case 15: {
                if (eventNode == null) break;
                if (eventNode instanceof VWConfigAppSpaceNode) {
                    newEvent = new VWCoordinationEvent(this, 762, itemName);
                }
                if (eventNode instanceof VWConfigEventLogNode) {
                    newEvent = new VWCoordinationEvent(this, 782, itemName);
                }
                if (eventNode instanceof VWConfigQueueNode) {
                    newEvent = new VWCoordinationEvent(this, 772, itemName);
                }
                if (!(eventNode instanceof VWConfigRosterNode)) break;
                newEvent = new VWCoordinationEvent(this, 777, itemName);
                break;
            }
            case 2: {
                newEvent = new VWCoordinationEvent(this, 756, null);
            }
        }
        if (newEvent != null) {
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(newEvent);
        }
    }

    public void configActionPerformed(VWConfigActionEvent event) {
        try {
            VWConfigBaseNode baseNode = event.getBaseNode();
            if (event.changedFocus() && this.m_focus != baseNode) {
                this.m_focus = baseNode;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWResource.Action) == 0) {
                JButton aButton = (JButton)event.getSource();
                this.displayActionMenu(aButton, 0, aButton.getHeight());
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_APPSPACE_PROPERTIES) == 0) {
                this.m_performer.performAppSpaceProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMMIT) == 0) {
                if (this.m_performer.performCommit(this.m_focus)) {
                    this.setFocusToFirstRegionNode();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMPONENT_PROPERTIES) == 0) {
                this.m_performer.performComponentQueueProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMPONENT_REGISTRATION) == 0) {
                this.m_performer.performComponentRegistration(this.m_focus);
                this.m_vwScopePane.getConfigScopeViewPane().setFocus(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_CREATE_XLIFF_FILE) == 0) {
                this.m_performer.performCreateXliffFile(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_DELETE) == 0) {
                VWConfigBaseNode newFocusNode = this.m_performer.performDeleteItem(this.m_focus);
                if (newFocusNode != null) {
                    this.m_focus = newFocusNode;
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 48));
                    this.m_vwScopePane.getConfigScopeViewPane().setFocus(this.m_focus);
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_DISCARD) == 0) {
                this.performDiscardItemAction();
                this.m_vwScopePane.getConfigScopeViewPane().setFocus(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_EVENTLOG_PROPERTIES) == 0) {
                this.m_performer.performEventLogProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_EXPORT) == 0) {
                this.m_performer.performExport(this.m_focus);
                this.m_vwScopePane.getConfigScopeViewPane().setFocus(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_IMPORT) == 0) {
                this.m_performer.performImport(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.m_vwScopePane.getConfigScopeViewPane().setFocus(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_APPSPACE) == 0) {
                this.m_performer.performNewAppSpace(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_COMPONENT) == 0) {
                this.m_performer.performNewComponent(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_EVENTLOG) == 0) {
                this.m_performer.performNewEventLog(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_QUEUE) == 0) {
                this.m_performer.performNewQueue(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_ROSTER) == 0) {
                this.m_performer.performNewRoster(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_PUBLISH_UDDI) == 0) {
                this.m_performer.performPublishToUDDI(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_PUBLISH_WSRR) == 0) {
                this.m_performer.performPublishToWSRR(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_QUEUE_PROPERTIES) == 0) {
                this.m_performer.performQueueProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REFRESH) == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (this.m_focus == null) {
                    this.m_focus = this.m_consoleRoot;
                }
                switch (this.m_focus.getType()) {
                    case 17: {
                        this.m_consoleRoot.refresh();
                        break;
                    }
                    case 18: {
                        VWConfigVWServiceNode sNode = (VWConfigVWServiceNode)this.m_focus;
                        sNode.refresh();
                        break;
                    }
                    case 19: {
                        VWConfigRegionNode rNode = (VWConfigRegionNode)this.m_focus;
                        rNode.refresh(true);
                        break;
                    }
                    default: {
                        VWConfigRegionNode rgNode = (VWConfigRegionNode)this.m_focus.findAncestorNode(19);
                        if (rgNode == null) break;
                        rgNode.refresh(true);
                        this.m_focus = rgNode;
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 48));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REGION_PROPERTIES) == 0) {
                this.m_performer.performRegionProperties(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_ROSTER_PROPERTIES) == 0) {
                this.m_performer.performRosterProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_UP) == 0) {
                this.performUpButtonAction();
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_VERIFY_XLIFF_FILE) == 0) {
                this.m_performer.performVerifyXliffFile(this.m_focus);
                this.m_vwToolBar.requestFocus();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_HELP_TOPICS) == 0) {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc012.htm");
            } else {
                System.out.println("unhandled event - " + actionCMD);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        if (event.getSource() == this) {
            return;
        }
        this.setFocusToFirstRegionNode();
        switch (event.getID()) {
            case 761: {
                this.m_performer.notifyOfChangedAppSpace(this.m_focus, (String)event.getEventParam());
                break;
            }
            case 771: {
                this.m_performer.notifyOfChangedQueue(this.m_focus, (String)event.getEventParam());
                break;
            }
            case 765: {
                this.m_performer.notifyOfAddedStepProcessor(this.m_focus);
            }
        }
    }

    protected void addConfigActionListener(IVWConfigActionListener listener) {
        this.m_listenerList.add(IVWConfigActionListener.class, listener);
    }

    protected void fireConfigActionEvent(VWConfigActionEvent evt) {
        if (evt == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWConfigActionListener.class) continue;
            ((IVWConfigActionListener)listeners[i + 1]).configActionPerformed(evt);
        }
    }

    private void createControls() {
        try {
            String baseURL = this.m_designerCoreData.getSessionInfo().getProperty("baseURL");
            if (baseURL != null && baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            this.m_modifiedNodes = new Vector();
            this.m_consoleRoot = new VWDesignerRootNode(baseURL, this.m_designerCoreData);
            this.m_consoleRoot.setupIsolatedRegions(this.m_designerCoreData.getSessionInfo());
            this.m_consoleRoot.setModifiedNodeList(this.m_modifiedNodes);
            this.m_configData = this.m_consoleRoot;
            this.m_focus = this.m_consoleRoot;
            Vector regionNodes = this.m_consoleRoot.getAllRegions(true);
            if (regionNodes != null && regionNodes.size() > 0) {
                this.m_focus = (VWConfigRegionNode)regionNodes.elementAt(0);
            }
            this.setLayout(new BorderLayout());
            this.m_vwToolBar = new VWConfigToolBar(this, 1);
            this.add((Component)this.m_vwToolBar, "First");
            this.m_vwChangesPane = new VWConfigChangesPane(this.m_modifiedNodes);
            this.m_vwScopePane = new VWConfigScopePane();
            this.m_vwScopePane.init(this.m_consoleRoot, this.m_performer);
            this.m_vwContentPane = new VWConfigContentPane();
            this.m_vwContentPane.init(this.m_consoleRoot, 0, this.m_performer);
            VWSplitPane viewSplitPane = new VWSplitPane(0, this.m_vwContentPane, this.m_vwChangesPane);
            viewSplitPane.setToolTipText(VWResource.SlideToAdjustView);
            viewSplitPane.setOneTouchExpandable(true);
            viewSplitPane.setDividerSize(6);
            viewSplitPane.setDividerLocation(0.7);
            VWSplitPane rootSplitPane = new VWSplitPane(1, this.m_vwScopePane, viewSplitPane);
            rootSplitPane.setToolTipText(VWResource.SlideToAdjustView);
            rootSplitPane.setOneTouchExpandable(true);
            rootSplitPane.setDividerSize(6);
            rootSplitPane.setDividerLocation(0.25);
            this.add((Component)rootSplitPane, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void displayActionMenu(Component parent, int x, int y) {
        VWPopupMenu mi = null;
        switch (this.m_focus.getType()) {
            case 19: {
                VWConfigRegionNode rNode = (VWConfigRegionNode)this.m_focus;
                if (rNode.getSessionInfo() == null) {
                    mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 5, this, this.m_focus);
                    break;
                }
                mi = new VWConfigContextMenu(rNode.getSessionInfo(), 2, this, this.m_focus);
                ((VWConfigContextMenu)mi).setRegionMenus((VWConfigRegionNode)this.m_focus);
                break;
            }
            case 24: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 6, this, this.m_focus);
                break;
            }
            case 20: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 7, this, this.m_focus);
                break;
            }
            case 21: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 8, this, this.m_focus);
                break;
            }
            case 22: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 9, this, this.m_focus);
                break;
            }
            case 23: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 10, this, this.m_focus);
                break;
            }
            case 25: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 11, this, this.m_focus);
                break;
            }
            case 16: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 17, this, this.m_focus);
                break;
            }
            case 5: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 12, this, this.m_focus);
                break;
            }
            case 1: 
            case 2: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 13, this, this.m_focus);
                break;
            }
            case 3: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 14, this, this.m_focus);
                break;
            }
            case 4: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 15, this, this.m_focus);
                break;
            }
            case 6: {
                mi = new VWConfigContextMenu(this.m_designerCoreData.getSessionInfo(), 16, this, this.m_focus);
            }
        }
        if (mi != null) {
            mi.show(parent, x, y);
        }
    }

    private void performDiscardItemAction() {
        switch (this.m_focus.getType()) {
            case 17: 
            case 18: 
            case 19: {
                this.m_performer.performDiscard(this.m_focus, true, true);
                break;
            }
            default: {
                VWConfigRegionNode rNode = (VWConfigRegionNode)this.m_focus.findAncestorNode(19);
                if (this.m_performer.performDiscard(rNode, true, true) != 0) break;
                this.m_focus = rNode;
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
            }
        }
        this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
    }

    private void performUpButtonAction() {
        VWConfigBaseNode aNode = (VWConfigBaseNode)this.m_focus.getParent();
        if (aNode != null) {
            this.m_focus = aNode;
            this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
        }
    }

    private void setFocusToFirstRegionNode() {
        Vector regionNodes = this.m_consoleRoot.getAllRegions(true);
        if (regionNodes != null && regionNodes.size() > 0) {
            this.m_focus = (VWConfigRegionNode)regionNodes.elementAt(0);
            this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 48));
            this.m_vwScopePane.getConfigScopeViewPane().setFocus(this.m_focus);
        }
    }
}

